# usage: awk -f rd_dst.awk  alt_tmp.dst
# the input alt_tmp.tkr is merged and sorted by write_scr and sdf_timing information
# format of alt_tmp.tkr: end_path type start_path delay [uncertainty]
# the valid types are: CKCYL, CKSKW, CSU, ,INCK, OUTCK, TCO, TPD and FMAX

BEGIN {FS= " "; prev= " "; out_tpd= 0; out_tco= 0; outck= " ";}

$1 != prev {
 	    if (out_tpd == 1 || out_tco == 1)  
	    {
	      if (out_tpd == 1)
	      {
               printf("%s ASSGN %s %s %s\n", prev, min_tpd, max_tpd, max_tpd - min_tpd)>> "alt_tmp.tpo";
	      }
	      if (out_tco == 1)
	      {
	      if (set_out_clk == 0 )  # no clock specified
                printf("%s :TCO \"%.2fns {synopsys}\"\n", prev, min_tco);
	      else
		printf("%s\tTCO  %s %s\n", outck, prev, min_tco) >> "alt_tmp.tco";
	      }
	    }

	    prev= $1;
	    out_tco= 0; min_tco= 9999; outck= " "; set_out_clk= 0;
	    out_tpd= 0; min_tpd= 9999; max_tpd= 0;
       	    clk_skew= 0; uncertainty= 0; cell_tsu= 0;
	   }
$2 ~ /TPD/ {
	    out_tpd = 1;
            if ($4 < min_tpd)
            min_tpd = $4;
            if ($4 > max_tpd)
            max_tpd = $4;
#	    print ($3,$2, $1, $4) >> "alt_tmp.tpi";
	    print ($1,$2, $3, $4) >> "alt_tmp.tpo";
      	   }

$2 ~ /CKCYL/ {
	      print ($3, $2, $1, fmax) >> "alt_tmp.fmx";
             }
$2 ~ /CKSKW/ {clk_skew= $4; uncertainty= $5;
	       if ( $3 !~ /CKSKW/ )
	       { print $0 >> "alt_tmp.tco";}
             }
$2 ~ /CSU/ {cell_tsu= $4;}
$2 ~ /INCK/ {
	      printf("%s %s %s %s %s\n",$3,$2,$1,clk_skew,uncertainty) >> "alt_tmp.tsu";}
$2 ~ /OUTCK/ {set_out_clk= 1; outck= $3;}
$2 ~ /TCO/ {
	    out_tco = 1;
            if ($4 < min_tco)
            min_tco = $4;
	    }

$2 ~ /TSU/ {
            tsu= $4 + cell_tsu;
	    print ($3, $2, $1, tsu) >> "alt_tmp.tsu";
           }

$2 ~ /FMAX/ {
	    fmax= $4 +cell_tsu -clk_skew + uncertainty;
	    print (fmax, $2, $3, $1) >> "alt_tmp.fmx";
            }
END { # ouput last record
 	    if (out_tpd == 1 || out_tco == 1)  
            {
              if (out_tpd == 1)
              { 
               printf("%s ASSGN %s %s %s\n", prev, min_tpd, max_tpd, max_tpd - min_tpd)>> "alt_tmp.tpo";
              }
	      if (out_tco == 1)
	      {
              if (set_out_clk == 0 )  # no clock specified
                printf("%s :TCO \"%.2fns {synopsys}\"\n", prev, min_tco);
              else
                printf("%s\tTCO  %s %s\n", outck, prev, min_tco) >> "alt_tmp.tco";
              }
	    }
}
